dnl File   : assert.m4
dnl Author : Richard A. O'Keefe
dnl SCCS   : "@(#)97/11/14 assert.m4   1.2"
dnl Purpose: Implement assert(Condition) for Encore Pascal.
dnl
dnl Before we begin, a great big RASPBERRY to Encore Pascal.
dnl Most Pascals provide a `halt' procedure that stops the program.
dnl Not only do Encore call theirs `exitst' (which I keep trying to
dnl type as `exists') but it isn't even predeclared!
dnl
ifdef(`halt',,
    procedure exitst(status: integer); external;
    `define(`halt', exitst(1))'
)dnl
define(`STRING',
    '`$1'')dnl
define(`assert',
    ifdef(`NDEBUG',
       `begin (* assume $1 *) end',
       `__nofile__',
       `begin if not ($1) then begin
       writeln(ifelse($#,2,$2,STRING(__file__: ($1) is FALSE)); halt end end',
       `begin if not ($1) then begin
       writeln(ifelse($#,2,$2,STRING(($1) is FALSE)); halt end end'))dnl
