dnl File   : atexit.m4
dnl Author : Richard A. O'Keefe
dnl SCCS   : "@(#)97/11/10 atexit.m4   1.1"
dnl Purpose: Provide a C-like atexit()
dnl
dnl m4wrap(`stuff') causes the `stuff' to be processed at the end of
dnl everything else, PROVIDED that m4wrap() isn't called before then.
dnl There's no way to stack these things, unlike onexit() in C.
dnl atexit() pushes an atcion on a stack, so that several exit actions
dnl can be performed.  The old implementation was
dnl
dnl define(M4_exit_action)dnl
dnl define(atexit,`define(`M4_exit_action',`$1'defn(`M4_exit_action'))')
dnl m4wrap(`M4_exit_action')dnl
dnl
dnl but that involves copying strings a lot.  It is better to use pushdef/
dnl popdef.
define(`M4_exit_action',`')dnl
define(`atexit',
  `pushdef(`M4_exit_action',
    `$1`'popdef(`M4_exit_action')`'M4_exit_action()')')dnl
m4wrap(``'M4_exit_action()')dnl
