/*  Header : chtype.h
    Author : Richard A. O'Keefe
    Updated: 11/14/97
    Purpose: Classify characters and convert them to numeric values.

    stdio.h   provides EOF
*/
#ifndef CHTYPE_H_
#include <stdio.h>

#define DIGIT_0  0
#define DIGIT_1  1
#define DIGIT_2  2
#define DIGIT_3  3
#define DIGIT_4  4
#define DIGIT_5  5
#define DIGIT_6  6
#define DIGIT_7  7
#define DIGIT_8  8
#define DIGIT_9  9
#define DIGIT_A 10
#define DIGIT_B 11
#define DIGIT_C 12
#define DIGIT_D 13
#define DIGIT_E 14
#define DIGIT_F 15
#define DIGIT_G 16
#define DIGIT_H 17
#define DIGIT_I  18
#define DIGIT_J 19
#define DIGIT_K 20
#define DIGIT_L  21
#define DIGIT_M 22
#define DIGIT_N 23
#define DIGIT_O 24
#define DIGIT_P 25
#define DIGIT_Q 26
#define DIGIT_R  27
#define DIGIT_S 28
#define DIGIT_T 29
#define DIGIT_U 30
#define DIGIT_V 31
#define DIGIT_W 32
#define DIGIT_X 33
#define DIGIT_Y 34
#define DIGIT_Z 35

extern int  chtype[];
extern unsigned char dncase[];

extern void init_chtype P0(void);

#ifdef  EXTENDED

typedef int (*cmpfn) P2(char const *, char const *);
extern  int   dncmp  P2(char const *, char const *);
extern  cmpfn compare;

#else

#define compare strcmp

#endif

#define is_sym1(c) (chtype[(c)-EOF] >= 10)
#define is_sym2(c) (chtype[(c)-EOF] >=  0)
#define is_blnk(c) ((unsigned)(c) - (unsigned)1 < (unsigned)' ')
#define digval(c)  chtype[(c)-EOF]

#define CHTYPE_H_
#endif
