/*  Header : common.h
    Author : Richard A. O'Keefe
    Updated: 11/14/97
    Defines: H0, H1, H2, H3, H4, and maybe const

    The purpose of this stuff is to let you use new-style function
    headers when compiling the program using an ISO-C compiler, or
    use old-style function headers when using a "Classic C" one.
    Use r f Hi(t1,v1, ..., ti,vi) {...} to define a function f with
    result type r and i arguments.
    Use r f Pi(t1,...,ti) to declare such a function.  Note that
    the declaration form DOES not have argument names and SHOULD not;
    it's not an oversight, putting argument names in prototypes is
    DANGEROUS and should never be done.
*/

#ifdef  __STDC__
#define H0(v) (v)
#define H1(t1,v1) (t1 v1)
#define H2(t1,v1,t2,v2) (t1 v1, t2 v2)
#define H3(t1,v1,t2,v2,t3,v3) (t1 v1, t2 v2, t3 v3)
#define H4(t1,v1,t2,v2,t3,v3,t4,v4) (t1 v1, t2 v2, t3 v3, t4 v4)
#define P0(v) (v)
#define P1(t1) (t1)
#define P2(t1,t2) (t1,t2)
#define P3(t1,t2,t3) (t1,t2,t3)
#define P4(t1,t2,t3,t4) (t1,t2,t3,t4)
#else
#define H0(v) ()
#define H1(t1,v1) (v1) t1 v1;
#define H2(t1,v1,t2,v2) (v1,v2) t1 v1; t2 v2;
#define H3(t1,v1,t2,v2,t3,v3) (v1,v2,v3) t1 v1; t2 v2; t3 v3;
#define H4(t1,v1,t2,v2,t3,v3,t4,v4) (v1,v2,v3,v4) t1 v1; t2 v2; t3 v3; t4 v4;
#define P0(v) ()
#define P1(t1) ()
#define P2(t1,t2) ()
#define P3(t1,t2,t3) ()
#define P4(t1,t2,t3,t4) ()
#define const
#endif

