/*  Header : extr.h
    Author : Ozan Yigit
    Editor : Richard A. O'Keefe
    Updated: 11/20/97
*/
#ifndef putback

extern ndptr hashtab[];      /* hash table for macros etc.  */
extern char  buf[];    /* push-back buffer         */
extern char *bp;    /* first available character   */
extern char *bb;    /* current beginning of bp     */
extern char *endpbb;      /* end of push-back buffer     */
extern stae  mstack[];    /* stack of m4 machine         */
extern char *ep;    /* first free char in strspace */
extern char *endest;      /* end of string space         */
extern int   sp;    /* current m4  stack pointer   */
extern int   fp;    /* m4 call frame pointer       */
extern char *bbstack[];
extern char *inname[];    /* input file name stack       */
extern FILE *infile[];    /* input file stack (0=stdin)  */
extern FILE *outfile[];      /* diversion array(0=bitbucket)*/
extern FILE *active;      /* active output file pointer  */
extern FILE *ifile;    /* current input file          */
extern char *m4temp;      /* filename for diversions     */
extern int   UNIQUE;      /* where to change m4temp      */
extern int   ilevel;      /* input file stack pointer    */
extern int   oindex;      /* diversion index..        */
extern int   sysval;      /* result of last system()call */
extern char *null;     /* as it says.. just a null..  */

extern char dfltchrs[12]; /* default string table        */
#define LQUOTE dfltchrs+0 /* default left quote          */
#define RQUOTE dfltchrs+2 /* default right quote         */
#define VQUOTE dfltchrs+4 /* default verbatim quote      */
#define SCOMMT dfltchrs+6 /* default comment start       */
#define ECOMMT dfltchrs+8 /* default comment end         */
#define XCOMMT dfltchrs+10   /* default comment scape       */
extern char *lquote;      /* left quote string  (`)      */
extern char *rquote;      /* right quote string (')      */
extern char *vquote;      /* verbatim quote string ^V    */
extern char *scommt;      /* start string for comments   */
extern char *ecommt;      /* end string for comments     */
extern char *xcommt;      /* escape string for comments  */

/* inlined versions of chrsave() and putback() */

extern char  memsg[];     /* memory allocation error */
extern char  pbmsg[];     /* error message for putback */
extern char  csmsg[];     /* error message for chrsave */

#define putback(c) do { if (bp >= endpbb) error1(pbmsg); *bp++ = c; } while (0)
#define chrsave(c) do { if (ep >= endest) error1(csmsg); *ep++ = c; } while (0)

/* getopt() interface */

extern  char *   optarg;
extern  int   optind;
#ifdef  __STDC__
extern  int   getopt(int, char *const *, char const *);
#else
extern  int   getopt();
#endif

#include "common.h"

#ifdef  __STDC__
#include <stdlib.h>
#include <string.h>
#else
#define EXIT_SUCCESS 0
#define EXIT_FAILURE 1
#ifdef  VOID
#define void  int
#define generic  char
#else
#define generic void
#endif
extern  void  exit P1(int);
extern  generic*malloc P1(int);
extern  void  free P1(char *);
extern  int   strlen P1(char const *);
extern  int   strcmp P2(char const *, char const *);
extern  char *   strcpy P2(char *, char const *);
extern  generic*memcpy P3(char *, char const *, int);
#endif

/* functions from misc.c */

extern  char *   dupstr P1(char const *);
extern  void  strsave P1(char const *);
extern  int   indx P2(char const *, char const *);
extern  void  pbstr P1(char const *);
extern  void  pbqtd P1(char const *);
extern  void  prqtd P2(FILE *, char const *);
extern  void  prstr P2(FILE *, char const *);
extern  void  pbnum P1(int);
extern  void  pbrad P3(long int, int, int);
extern  void  getdiv P1(int);
extern  void  flushall P0(void);
extern  void  m4exit P1(int);
extern  void  error2 P2(char const *, char const *);
extern  void  error1 P1(char const *);
extern  void  onintr P1(int);
extern  void  usage P0(void);
extern  int   incopen P1(char const *);
extern  void  inclose P0(void);

/* functions from look.c */

#define HUPDATE(h, c) (h) += (c)

extern  ndptr lookup P1(char const *);
extern  ndptr addent P1(char const *);
extern  void  remhash P2(char const *, int);
extern  void  addkywd P3(char const *, char const *, int);

/* functions from int2str.c */

extern  char* int2str P3(char const *, int, long);

/* functions from serv.c */

extern  void  expand P2(stae const *, int);
extern  void  dodefine P2(char const *, char const *);
extern  void  dopushdef P2(char const *, char const *);
extern  void  dodefn P1(char const *);
extern  void  dodump P2(stae const *, int);
extern  void  doifelse P2(stae const *, int);
extern  void  doifdef P2(stae const *, int);
extern  void  dochq P2(stae const *, int);
extern  void  dochc P2(stae const *, int);
extern  void  dodiv P1(int);
extern  void  doundiv P2(stae const *, int);
extern  void  dosub P2(stae const *, int);
extern  void  translit P4(char *, char const *, char const *, int);
#ifdef  EXTENDED
extern  int   dopaste P1(char const *);
extern  void  m4trim P2(stae const *, int);
extern  void  dodefqt P2(stae const *, int);
extern  void  doqutr P2(stae const *, int);
#endif

/* functions from expr.c */

extern  long  expr P1(char const *);
extern  void  experr P1(char const *);

/* functions from divide.c */

extern  long  divide P3(long, long, int);

#endif
