dnl File   : indir.m4
dnl Author : Richard A. O'Keefe
dnl SCCS   : "@(#)97/11/13 indir.m4    1.1"
dnl Defines: GNU m4's indir() macro
dnl
dnl The idea is that indir(name, arg1, ..., argn) is the same as
dnl name(arg1, ..., argn) except that name may be calculated and
dnl need not have the form of an identifier.  We work around that
dnl by copying its definition to a private macro __indir.  It is
dnl not clear what we should do if name is not defined; currently
dnl we report the error and quit.
dnl
define(`__indir')dnl
define(`indir',
   `ifdef(`$1',
       `define(`__indir',defn(`$1'))__indir($[2@$])',
       `errprint(`indir: `$1' is not defined')')')dnl
