/*  Header : mdef.h
    Author : Ozan Yigit
    Updated: 11/20/97
*/
#ifndef MACRTYPE

#include <stdio.h>

/*  m4 constants */

#define MACRTYPE        1
#define DEFITYPE        2
#define EXPRTYPE        3
#define SUBSTYPE        4
#define IFELTYPE        5
#define LENGTYPE        6
#define CHNQTYPE        7
#define SYSCTYPE        8
#define UNDFTYPE        9
#define INCLTYPE        10
#define SINCTYPE        11
#define PASTTYPE        12
#define SPASTYPE        13
#define INCRTYPE        14
#define IFDFTYPE        15
#define PUSDTYPE        16
#define POPDTYPE        17
#define SHIFTYPE        18
#define DECRTYPE        19
#define DIVRTYPE        20
#define UNDVTYPE        21
#define DIVNTYPE        22
#define MKTMTYPE        23
#define ERRPTYPE        24
#define M4WRTYPE        25
#define TRNLTYPE        26
#define DNLNTYPE        27
#define DUMPTYPE        28
#define CHNCTYPE        29
#define INDXTYPE        30
#define SYSVTYPE        31
#define EXITTYPE        32
#define DEFNTYPE        33
#define LINETYPE 34
#define TRIMTYPE 35
#define TLITTYPE 36
#define DEFQTYPE 37    /* defquote */
#define QUTRTYPE 38    /* quoter thus defined */
#define FILETYPE 39    /* __file__ */
#define GENVTYPE 40    /* m4getenv */

/* m4 fixed special characters */

#define ARGFLAG         '$'
#define BIMCHAR     '!'      /* Built-in macro flag */
#define LPAREN          '('
#define RPAREN          ')'
#define COMMA           ','

/*
 * other important constants
 */

#define EOS             (char) 0
#define MAXOUT          10              /* maximum # of diversions */

#ifdef  SMALL          /* System V (PDP11) limits */
#define MAXINP              10          /* maximum include files   */
#define MAXTOK             512          /* maximum chars in token  */
#define BUFSIZE         (4<<10)         /* size of pushback buffer */
#define STACKMAX        (1<<10)         /* size of call stack      */
#define STRSPMAX        (4<<10)         /* size of string space    */
#define HASHSIZE           199          /* maximum size of hashtab */
#else
#ifdef  MEDIUM
#define MAXINP               15         /* maximum include files   */
#define MAXTOK          ( 1<<10)        /* maximum chars in token  */
#define BUFSIZE         (10<<10)        /* size of pushback buffer */
#define STACKMAX        ( 2<<10)        /* size of call stack      */
#define STRSPMAX        (10<<10)        /* size of string space    */
#define HASHSIZE            509         /* maximum size of hashtab */
#else
#define MAXINP               20         /* maximum include files   */
#define MAXTOK          ( 8<<10)        /* maximum chars in token  */
#define BUFSIZE         (63<<10)        /* size of pushback buffer */
#define STACKMAX        ( 8<<10)        /* size of call stack      */
#define STRSPMAX        (63<<10)        /* size of string space    */
#define HASHSIZE            509         /* maximum size of hashtab */
#endif
#endif

#define ALL             1
#define TOP             0

/* m4 data structures */

typedef struct ndblock *ndptr;

struct ndblock                  /* hashtable structure        */
    {
        char    *name;          /* entry name..               */
        char    *defn;          /* definition..               */
        int     type;           /* type of the entry..        */
        ndptr   nxtptr;         /* link to next entry..       */
    };

#undef  nil      /* Avoid name conflict.  Otherwise no effect. */
#define nil     ((ndptr) 0)

typedef union       /* stack structure */
    {
   int  sfra;    /* frame entry  */
   char    *sstr;      /* string entry */
    } stae;

#define arg(n) argv[n].sstr  /* nth string in argument vector */

/*
 *     .               .
 * |   .   |  <-- sp      |  .  |
 * +-------+        +-----+
 * | arg 3 ----------------------->| str |
 * +-------+        |  .  |
 * | arg 2 ---PREVEP-----+      .
 * +-------+        |
 *     .            |     |     |
 * +-------+        |  +-----+
 * | plev  |  PARLEV     +-------->| str |
 * +-------+        |  .  |
 * | type  |  CALTYP         .
 * +-------+
 * | prcf  ---PREVFP--+
 * +-------+        |
 * |   .   |  PREVSP  |
 *     .            |
 * +-------+     |
 * | <----------+
 * +-------+
 *
 */
#define PARLEV  (mstack[fp].sfra)
#define CALTYP  (mstack[fp-1].sfra)
#define PREVEP   (mstack[fp+3].sstr)
#define PREVSP   (fp-3)
#define PREVFP   (mstack[fp-2].sfra)

#endif
