/*  Header : os.h
    Author : Richard A. O'Keefe
    Updated: 11/19/97
    Purpose: Handle the OS interface
*/

/*  When you build pdm4, you should define one of the following macros:

    Stream-oriented file systems:

   unix The operating system is POSIX-compatible, and is to be
     used via the POSIX interface.

   msdos   The operating system is some version of MS-DOS, 3.3 or
     later.  Currently, this is also used for Windows.  It'd
     be nice if someone with some Win32 knowledge adpated
     pdm4 to the Win32 environment.

   macos   The operating system is MacOS 6.x, 7.x, or 8.x.
     This has not yet been tested.  mktemp() emulation in
     particular needs testing.

     I have included patches that someone gave me for MacOS,
     but with my antique version of Think C, main.c gets a code
     overflow, so I have not been able to test it.  All the other
     files do at least compile without errors.

   [os2]   Jack J. Woehr has provided makefiles to build PD m4
     under OS/2, using several compilers.  However, his
     makefiles define 'unix'.  This may not be altogether
     appropriate.

    Record-oriented file systems:

   vms  The operating system is VMS.  The last time this was
     tested was with VMS 5.something on a VAX.

   ibmvm   The operating system is VM/CMS.

   mvs  The operating system is MVS.
     This one has not been done at all.

    Currently, the only things that depend on this are

   - how to make a temporary file name in a pre-ANSI C.

   - whether system() is available

   - which system macro to predefine for M4 code (one of these names
     will be used)

    MacOS doesn't really believe in command lines, and while Think C can
    give you a command line interface, it's a bit of a kluge.  Adapting
    pdm4 to MacOS would require some workaround for this.

    How do you set the option?
    - You can edit this file.
    - You can put -Dxxxx in the command line.
    - You can tell your IDE what to predefine for C.
    In the version of Turbo C I used for the msdos port, -Dxxx on the
    command line defined xxx to be _empty_, not to be 1.  In order to
    protect against such problems, this file ensures that _all_ of the
    macros are defined, exactly one of them is defined to be 1, and the
    others are defined to be 0.
*/

#ifdef  __unix__
#undef  unix
#define unix
#endif
#ifdef  __unix
#undef  unix
#define unix
#endif

#ifdef  __MSVC__
#undef  msdos
#define msdos
#endif

#ifdef  THINK_C
#undef  macos
#define macos
#endif
#ifdef  __MWERKS__
#undef  macos
#define macos
#define main(x,y) MAIN(x,y)
#endif

#ifdef  unix
#undef  unix
#undef  msdos
#undef  macos
#undef  vms
#undef  ibmvm
#undef  mvs
#define unix 1
#else
#define unix 0
#endif

#ifdef  msdos
#undef  msdos
#undef  macos
#undef  vms
#undef  ibmvm
#undef  mvs
#define msdos 1
#else
#define msdos 0
#endif

#ifdef  macos
#undef  macos
#undef  vms
#undef  ibmvm
#undef  mvs
#define macos 1
#else
#define macos 0
#endif

#ifdef  vms
#undef  vms
#undef  ibmvm
#undef  mvs
#define vms 1
#else
#define vms 0
#endif

#ifdef  ibmvm
#undef  ibmvm
#undef  mvs
#undef  GETOPT      /* Jack J. Woehr suggests */
#define GETOPT      /* using this for VM/CMS. */
#define ibmvm 1
#else
#define ibmvm 0
#endif

#ifdef  mvs
#undef  mvs
#define mvs 1
#else
#define mvs 0
#endif

#if unix
#ifndef HAS_SYSCMD
#define HAS_SYSCMD 2
#endif
#endif

#if msdos || vms | ibmvm
#ifndef HAS_SYSCMD
#define HAS_SYSCMD 1
#endif
#endif

#ifndef HAS_SYSCMD
#define HAS_SYSCMD 0
#endif

#if !(unix|msdos|macos|vms|ibmvm|mvs)
#error You must specify a known operating system.
#endif

#ifdef  __STDC__
#include <stdlib.h>
#include <stdio.h>
#else
extern  int   system(/* char* */);
extern  char* tmpnam(/* char* */);
#if  unix
extern  int   unlink(/* char* */);
#define remove   unlink
#else
extern  int   remove(/* char* */);
#endif
#endif

