/*  Header : ourlims.h
    Author : Richard A. O'Keefe
    Updated: 11/10/97
    Defines: UCHAR_MAX, CHAR_BIT, LONG_BIT
*/
/*  If <limits.h> is available, use that.
    Otherwise, use 8-bit byte as the default.
    If the number of characters is a power of 2, you might be able
    to use (unsigned char)(~0), but why get fancy?
*/
#ifndef OURLIMS_H_
#ifdef  __STDC__
#include <limits.h>
#else
#define UCHAR_MAX 255
#define CHAR_BIT 8
#endif
#ifndef LONG_BIT
/* Sun, ever-helpful, define this in their limits.h */
#define LONG_BIT (CHAR_BIT * sizeof (long))
#endif
#define OURLIMS_H
#endif
