dnl File   : profile.m4
dnl Author : Richard A. O'Keefe
dnl SCCS   : "@(#)97/11/10 profile.m4  1.1"
dnl Purpose: Profiling Pascal source code.
dnl
dnl This file provides procedure-call counts
dnl -if- the macro PROFILING is defined.
dnl Otherwise the macros it defines do nothing.
dnl
dnl The basic scheme is that your program does
dnl    program foo(...);
dnl        Include(profile.m4)
dnl        ...
dnl        procedure p(...); ...
dnl            begin
dnl                enter(p);
dnl                ...
dnl                leave(p);
dnl            end;
dnl        ...
dnl        begin
dnl            enter(program);
dnl            ...
dnl            leave(program);
dnl        end.
ifdef(`PROFILING',
   `define(enter, `ifelse(`$1',`program',rewrite(EventLog, "EventLog");)
                  writeln(EventLog, "+ $1")')
    define(leave, `writeln(EventLog, "- $1")
                  ifelse(`$1',`program',; close(EventLog))')
    var EventLog: text;',
   `define(enter,)
    define(leave,)')

