dnl File   : rand.m4
dnl Author : Richard A. O'Keefe
dnl SCCS   : "@(#)97/11/10 rand.m4     1.1"
dnl Purpose: Generating random test data
dnl
define(RANDOM_MODULUS,233280)dnl
define(RANDOM_MULTIPLIER,9301)dnl
define(RANDOM_INCREMENT,49297)dnl
define(RANDOM_SEED,3321)dnl
define(NEXT_RANDOM,
   `define(`RANDOM_SEED', eval(
       ((RANDOM_SEED*'RANDOM_MULTIPLIER+RANDOM_INCREMENT`)%'
       RANDOM_MODULUS+RANDOM_MODULUS`)%'
       RANDOM_MODULUS`))')dnl
define(digit,`NEXT_RANDOM()eval(RANDOM_SEED%10)')dnl
define(digits,
    `ifelse($1,1,,`digits(decr($1))')digit()')dnl
define(letter,`NEXT_RANDOM()substr(ABCDEFGHIJKLMNOPQRSTUVWXYZ,
       eval(RANDOM_SEED%26), 1)')dnl
define(letters,
    `ifelse($1,1,,`letters(decr($1))')`'letter()')dnl
define(rpad, `substr(`$2',0,$1,`$3')')dnl
define(lpad, `substr(`$2',len(`$2')-$1,$1,`$3')')dnl
define(r_year,  `NEXT_RANDOM()eval(RANDOM_SEED%15+1976,10,4)')dnl
define(r_month, `NEXT_RANDOM()eval(RANDOM_SEED%12+1,10,2)')dnl
define(r_day,   `NEXT_RANDOM()eval(RANDOM_SEED%28+1,10,2)')dnl
define(r_date,  `r_year()/r_month()/r_day()')dnl
define(r_cust,  `digits(4)letter()')dnl
define(r_part,  `letters(2)-digits(5)-digits(2)')dnl
define(r_quant, `NEXT_RANDOM()lpad(3,eval(RANDOM_SEED%999+1))')dnl
define(r_price, `lpad(4,eval(digits(4)))')dnl
define(r_order, `r_date        r_cust  r_part  r_quant')
define(r_catal, `r_part        r_price')
define(repeat,
    `ifelse($1,0,,`$2($1)
repeat(decr($1),`$2')')')dnl
# 20 orders
repeat(20, `r_order')
# 20 catalogue entries
repeat(20, `r_catal')
