dnl File   : substr.m4
dnl Author : Richard A. O'Keefe
dnl SCCS   : "@(#)97/11/10 substr.m4   1.1"
dnl Purpose: Tests for substr().
dnl
# This file tests the substr macro.
Expect:        and get: substr(abc,-2,0,x)
Expect: x      and get: substr(abc,-2,1,x)
Expect: xx     and get: substr(abc,-2,2,x)
Expect: xxa    and get: substr(abc,-2,3,x)
Expect: xxab   and get: substr(abc,-2,4,x)
Expect: xxabc  and get: substr(abc,-2,5,x)
Expect:        and get: substr(abc,-1,0,x)
Expect: x      and get: substr(abc,-1,1,x)
Expect: xa     and get: substr(abc,-1,2,x)
Expect: xab    and get: substr(abc,-1,3,x)
Expect: xabc   and get: substr(abc,-1,4,x)
Expect: xabcx  and get: substr(abc,-1,5,x)
Expect:        and get: substr(abc,0,0,x)
Expect: a      and get: substr(abc,0,1,x)
Expect: ab     and get: substr(abc,0,2,x)
Expect: abc    and get: substr(abc,0,3,x)
Expect: abcx   and get: substr(abc,0,4,x)
Expect: abcxx  and get: substr(abc,0,5,x)
Expect:        and get: substr(abc,1,0,x)
Expect: b       and get: substr(abc,1,1,x)
Expect: bc      and get: substr(abc,1,2,x)
Expect: bcx     and get: substr(abc,1,3,x)
Expect: bcxx    and get: substr(abc,1,4,x)
Expect:        and get: substr(abc,2,0,x)
Expect: c       and get: substr(abc,2,1,x)
Expect: cx      and get: substr(abc,2,2,x)
Expect: cxx     and get: substr(abc,2,3,x)
Expect:        and get: substr(abc,3,0,x)
Expect: x       and get: substr(abc,3,1,x)
Expect: xx      and get: substr(abc,3,2,x)
Expect:        and get: substr(abc,4,0,x)
Expect: x       and get: substr(abc,4,1,x)
Expect:        and get: substr(abc,5,0,x)
# Now to test rotations.
# Note that it is important that x%0 should be harmless
# so that we can rotate the empty string.
define(rotate, `substr(`$1$1',($2)\len(`$1'),len(`$1'))')dnl
`rotate(abc,-3) = 'rotate(abc,-3)
`rotate(abc,-2) = 'rotate(abc,-2)
`rotate(abc,-1) = 'rotate(abc,-1)
`rotate(abc, 0) = 'rotate(abc, 0)
`rotate(abc, 1) = 'rotate(abc, 1)
`rotate(abc, 2) = 'rotate(abc, 2)
`rotate(abc, 3) = 'rotate(abc, 3)
# That's the end of the tests for now.
