dnl File   : translit.m4
dnl Author : Richard A. O'Keefe
dnl SCCS   : "@(#)97/11/13 translit.m4 1.1"
dnl Purpose: Test the translit() macro.
dnl
If the m4 `translit' macro acted like the UNIX `tr' command,
you would expect

    `translit'(c1...cn, f1...fm, t1...tn)

to yield d1...dn, where di is tj if ci is fj, otherwise di is ci.
What DOES it do?

First, let's see whether ranges are supported:
   `translit(abc, a-z, A-Z)' => translit(abc, a-z, A-Z)
If you got ABC, your `translit' accepts ranges.  IT SHOULD NOT.
If you got Abc, you have the correct output.

Second, does `translit' apply the mapping just once,
or does it in effect repeat the mapping until there is no change:
    di := ci;
    while exists (fj->tj) such that di = fj do di := tj
Let's try it:
   `translit(abc, ab, bc)' => translit(abc, ab, bc)
If you got ccc, your `translit' iterates the mapping.  IT SHOULD NOT.
If you got bcc, the mapping is applied just once, which is now right.

dnl In order to provide backwards compatibility for old pdm4, there is
dnl now an optional fourth argument.  If that argument is not empty, it
dnl causes the mapping to be iterated as it used to be.  For example,
dnl you could write
dnl    define(_translit, defn(`translit'))
dnl    define(`translit', `translit(`$1',`$2',``$3',1)')

What does `translit' do with a fourth argument?
   `translit(abc, ab, bc, 1)' => translit(abc, ab, bc, 1)
If you got ccc, your `translit' iterates the mapping.  IT SHOULD.
If you got bcc, your `translit' ignores trailing arguments.
