const version = 'Engaged UTF-8  0.2.999'
"use strict";
var postForm = document.getElementsByClassName("PostForm")[0]
if (postForm) postForm.setAttribute('accept-charset','utf-8')
var utfURL = new URL('https://user.well.com/engaged.cgi')
if (document.getElementsByClassName('TLTitle').length ? true : false) fixTopicList()
if (document.getElementById('KeepNew') ? true : false) fixPosts()

function fixPosts(){
    var kurl = new URL(document.getElementById('KeepNew').href)
    var knSearch = new URLSearchParams(kurl.search)
    var conference = knSearch.get('c')
    var topic = knSearch.get('t')
    var lastRead = knSearch.get('l')
    var global = knSearch.get('g')
    var docSearch = new URLSearchParams(location.search)  
    var responses = docSearch.get('q')  
    var frame = docSearch.get('f')
    var action = docSearch.get('a')
    var hasNew = document.getElementsByClassName('ShortCenter')[0] ? true : false
    if (hasNew) {
        utfURL.search = 'a=u&c=' + conference + '&t=' + topic
        if (frame) utfURL.search += '&f=0'
        if (lastRead) utfURL.search += '&l=' + lastRead
        if (responses) utfURL.search += '&q=' + responses
        if (global) utfURL.search += '&g=' + global            
    } else {
        utfURL.search = 'c=' + conference + '&t=' + topic
        if (frame) utfURL.search += '&f=0'     
        if (responses) utfURL.search += '&q=' + responses 
        if (action === 'r') utfURL.search += '&q=' + document.getElementById('JumpData').value 
    }
    var xhr = new XMLHttpRequest()
    xhr.overrideMimeType(`text/html; charset=utf-8`)
    xhr.open("GET", utfURL, true)
    xhr.onload = function () {
        if ((xhr.readyState === 4) && (xhr.status === 200) && conference) {
              var xnn = new XMLHttpRequest()
              utfURL.search = 't=' + topic + '&c=' + conference + '&f=0'
              if (responses) utfURL.search += '&q=' + responses
              xnn.open("GET", utfURL, true)
              xnn.send(null)
              parseAsc(xhr.responseText)
        }
    }
    xhr.send(null)
}

function parseAsc(resp) {
    var parser = new DOMParser()
    var utfDoc = parser.parseFromString(resp, 'text/html')
    var posts = document.querySelectorAll('div[class^="author-"]')
    var utfPosts = utfDoc.querySelectorAll('div[class^="author-"]')
    if (posts.length !== utfPosts.length) {return}
    var topicTitle = utfDoc.getElementById('TopicTitle').innerText
    var badUtfTopicTitle = (topicTitle.indexOf('�') > -1) ? true : false
    if (!badUtfTopicTitle) document.getElementById('TopicTitle').innerText = topicTitle
    for (var i = 0;i < posts.length;i++){
        if(posts[i] == undefined) {return}
        if(utfPosts[i] == undefined) {return}
        if (posts[i].getElementsByClassName('rpnum')[0].innerText !== utfPosts[i].getElementsByClassName('rpnum')[0].innerText) {return}
        var separator = posts[i].getElementsByClassName('tptitle')[0].innerHTML
        var utfSeparator = utfPosts[i].getElementsByClassName('tptitle')[0].innerHTML
        var sepNotutf = (separator.localeCompare(utfSeparator) == 0) ? true : false
        var badUtfSep = (utfSeparator.indexOf('�') > -1) ? true : false
        if (sepNotutf || badUtfSep) utfPosts[i].getElementsByClassName('tptitle')[0].innerHTML = separator
        if (!sepNotutf && !badUtfSep) posts[i].getElementsByClassName('tptitle')[0].innerHTML = utfSeparator
        var hiddenPost = (utfPosts[i].getElementsByClassName("Hidden").length > 0) ? true : false
        var badUtfPost = (utfPosts[i].innerHTML.indexOf('�') > -1) ? true : false
        if (!badUtfPost && !hiddenPost) posts[i].innerHTML = utfPosts[i].innerHTML
        else if (!badUtfPost && hiddenPost) {
          var hideLink = posts[i].getElementsByClassName('Centered')[0].innerHTML
          utfPosts[i].getElementsByClassName('Centered')[0].innerHTML = hideLink
          posts[i].innerHTML = utfPosts[i].innerHTML
        } //else if (badUtfPost) use posts[i].innerHTML by default
        var postText = posts[i].querySelector(".Post")
        if (postText) postText.innerHTML = postText.innerHTML.replace(/&amp;#(\d+);/g,decodeHtml)      
        posts[i].innerHTML = posts[i].innerHTML.replace(/\u2028/g,'\n')
        posts[i].innerHTML = posts[i].innerHTML.replace(/\u2029/g,'\n\n')
        posts[i].innerHTML = posts[i].innerHTML.replace(/target="_blank">/g,'target="_blank" rel="noreferrer">')//external link in post
        posts[i].innerHTML = posts[i].innerHTML.replace(/&amp;f=h">/g,'&amp;f=h" target="_blank">')//open bio in new tab
    }
}

function decodeHtml(match) {
    var txt = document.createElement("textarea")
    txt.innerHTML = match
    txt.value = txt.value.replace('&#8232;','\n')
    txt.value = txt.value.replace('&#8233;','\n\n')
    return txt.value
}

function fixTopicList() {
    var xhr = new XMLHttpRequest()
    xhr.overrideMimeType(`text/html; charset=utf-8`)
    xhr.open("GET", window.location.href, true)
    xhr.onload = function () {
        if ((xhr.readyState === 4) && (xhr.status === 200)) {
            var parser = new DOMParser()
            var utfDoc = parser.parseFromString(xhr.responseText, 'text/html')
            var utfTL = utfDoc.getElementsByClassName('TopicList').length
            if (utfTL > 0) fixTopicNames(utfDoc)
        }
    }
    xhr.send(null)
}

function fixTopicNames(utfDoc) {
  var titles = document.getElementsByClassName('TLTitle')
  var utfTitles = utfDoc.getElementsByClassName('TLTitle')
  if (titles.length != utfTitles.length) return
  for (var i = 0;i < titles.length;i++){
    var badUtfTitle = (utfTitles[i].innerHTML.indexOf('�') > -1) ? true : false
    if (!badUtfTitle) titles[i].innerHTML = utfTitles[i].innerHTML
  }
}